import websocket  # You can use either "python3 setup.py install" or "pip3 install websocket-client"

# to install this library.

try:
    import thread
except ImportError:
    import _thread as thread
import time


endpoint = "ENTER THE ENDPOINT HERE "
apikey = "ENTER THE APIKEY HERE " 



def Authenticate(ws):
    print("Authenticating...")
    ws.send('{"MessageType":"Authenticate","Password":"' + apikey + '"}')


def SubscribeRealtime(ws):
    Exchange = "NFO"                            # GFDL : Supported Values: NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "BANKNIFTY-I"              # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    Unsubscribe = "false"                       # GFDL : To stop data subscription for this symbol, send this value as "true"
    strMessage = '{"MessageType":"SubscribeRealtime","Exchange":"' + Exchange + '","Unsubscribe":"' + Unsubscribe + '","InstrumentIdentifier":"' + InstIdentifier + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def SubscribeSnapshot(ws):
    ExchangeName = "NSE"                            # GFDL : Supported Values: NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "SBIN"                          # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    Periodicity = "MINUTE"                           # GFDL : Supported values are : Minute, Hour
    Period = 1                                        # GFDL : Supported values are : 1,2,5,10,15,30 (for Minute Periodicity ONLY)
    Unsubscribe = "false"                            # GFDL : To stop data subscription for this symbol, send this value as "true"
    strMessage = '{"MessageType":"SubscribeSnapshot","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Period":' + f'{Period}' + ',"Periodicity":"' + Periodicity + '","Unsubscribe":"' + Unsubscribe + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuote(ws):
    ExchangeName = "NFO"                            # GFDL : Supported Values: NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "NIFTY-I"                       # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    isShortIdentifier = "false"                      # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    strMessage = '{"MessageType":"GetLastQuote","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier + '","InstrumentIdentifier":"' + InstIdentifier + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteShort(ws):
    ExchangeName = "NFO"                            # GFDL : Supported Values: NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "NIFTY-I"                       # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    isShortIdentifier = "false"                      # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    strMessage = '{"MessageType":"GetLastQuoteShort","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier + '","InstrumentIdentifier":"' + InstIdentifier + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteShortWithClose(ws):
    ExchangeName = "NFO"                            # GFDL : Supported Values: NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "NIFTY-I"                       # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    isShortIdentifier = "false"  # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    strMessage = '{"MessageType":"GetLastQuoteShortWithClose","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifier + '","InstrumentIdentifier":"' + InstIdentifier + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteArray(ws):
    ExchangeName = "NFO"
    isShortIdentifiers = "false"  # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    InstrumentIdentifiers = '[{"Value":"NIFTY-I"},{"Value":"BANKNIFTY-I"}]'
    strMessage = '{"MessageType":"GetLastQuoteArray","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifiers + '","InstrumentIdentifiers":' + InstrumentIdentifiers + '}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteArrayShort(ws):
    ExchangeName = "NFO"
    isShortIdentifiers = "false"  # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    InstrumentIdentifiers = '[{"Value":"NIFTY-I"},{"Value":"BANKNIFTY-I"}]'
    strMessage = '{"MessageType":"GetLastQuoteArrayShort","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifiers + '","InstrumentIdentifiers":' + InstrumentIdentifiers + '}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteArrayShortWithClose(ws):
    ExchangeName = "NSE"
    isShortIdentifiers = "false"  # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    InstrumentIdentifiers = '[{"Value":"WIPRO"},{"Value":"RELIANCE"}]'
    strMessage = '{"MessageType":"GetLastQuoteArrayShortWithClose","Exchange":"' + ExchangeName + '","isShortIdentifier":"' + isShortIdentifiers + '","InstrumentIdentifiers":' + InstrumentIdentifiers + '}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetSnapshot(ws):
    ExchangeName = "NSE"  # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Periodicity = "MINUTE"  # GFDL : Supported Values : Minute, Hour
    Period = 1  # GFDL : Supported Values : 1,2,3,5,10,15,20,30
    InstrumentIdentifiers = '[{"Value":"WIPRO"},{"Value":"RELIANCE"}]'
    isShortIdentifiers = "false"  # GFDL : When using contractwise symbol like NIFTY20JULFUT,
    strMessage = '{"MessageType":"GetSnapshot","Exchange":"' + ExchangeName + '","Periodicity":"' + Periodicity + '","Period":' + f'{Period}' + ',"isShortIdentifiers":"' + isShortIdentifiers + '","InstrumentIdentifiers":' + InstrumentIdentifiers + '}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetHistory(ws):
    ExchangeName = "NFO"  # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstIdentifier = "NIFTY-I"  # GFDL : String of symbol name : NIFTY-I, RELIANCE, NIFTY 50, NATURALGAS-I, USDINR-I
    Periodicity = "MINUTE"  # GFDL : [“TICK”]/[“MINUTE”]/[“HOUR”]/[“DAY”]/[“WEEK”]/[“MONTH”], default = [“TICK”]
    Period = 1  # GFDL : Numerical value 1, 2, 3…, default = 1
    From = 1741317900         #GFDL : Numerical value of UNIX Timestamp like ‘1388534400’
    To = 1741353900           #GFDL : Numerical value of UNIX Timestamp like ‘1388534400’
    Max = 0  # GFDL : Numerical value of number of rrecords to be return
    UserTag = "User1"  # GFDL : String hich will be returned in response
    isShortIdentifier = "false"  # GFDL : Represent the format of InstIdentifier if shor or long
    AdjustSplits ="false" # GFDL : If it is false it will give the data without Splits Adjusted data .
    strMessage = '{"MessageType":"GetHistory","Exchange":"' + ExchangeName + '","InstrumentIdentifier":"' + InstIdentifier + '","Periodicity":"' + Periodicity + '","Period":"' + str(
        Period) + '","From":' + str(From) + ',"To":'+ str(To) + ',"Max":' + str(Max) + ',"UserTag":"' + UserTag + '","isShortIdentifier":"' + isShortIdentifier + '","AdjustSplits":"'+AdjustSplits+'"}'
    ws.send(strMessage)
    print('SENT: ' + strMessage)
    
    

def GetInstrumentsOnSearch(ws):
    ExchangeName = "NFO"                        # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Search = "BANKNIFTY"  # GFDL : This is the search string
    # Product = "NIFTY"  # GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
    # InstrumentType = "FUTIDX"  # GFDL : Optional argument to filter the search by products like FUTIDX,FUTSTK,OPTIDX,OPTSTK,FUTCUR, FUTCOM, etc.
    OptionType = "PE"			#GFDL : Optional argument to filter the search by OptionTypes like CE, PE
    Expiry = "18SEP2024"	    #GFDL : Optional argument to filter the search by Expiry like 29APR2021
    StrikePrice = 51000 	    #GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
    # Series = "EQ"                                #GFDL : Optional argument to filter the search by Series like EQ, BE, BL, BM, BS, etc.
    # OnlyActive = "TRUE"   		            #GFDL : Optional argument (default=True) to control returned data. If false,even expired contracts are returned
    # DetailedInfo = "FALSE"                      #GFDL : Optional argument (default=False) to control returned data. If true, detailed information is returned
    strMessage = '{"MessageType":"GetInstrumentsOnSearch","Exchange":"' + ExchangeName + '","Search":"' + Search + '","OptionType":"' + OptionType + '","Expiry":"' + Expiry + '","StrikePrice":"' + StrikePrice + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetInstruments(ws):
    ExchangeName = "NSE"
    # InstrumentType = "FUTSTK"	                #GFDL : Optional argument to filter the search by products like FUTIDX, FUTSTK, OPTIDX, OPTSTK,
    # FUTCUR, FUTCOM, etc.
    # Product = "BANKNIFTY"			            #GFDL : Optional argument to filter the search by products like NIFTY, RELIANCE, etc.
    # OptionType = "PE"		                    #GFDL : Optional argument to filter the search by OptionTypes like CE, PE
    # Expiry = "18SEP2024"	                    #GFDL : Optional argument to filter the search by Expiry like 29APR2021
    # StrikePrice = 51000	    	            #GFDL : Optional argument to filter the search by Strike Price like 10000, 75.5, 1250, etc.
    # Series = "EQ"                                #GFDL : Optional argument to filter the search by Series like EQ, BE, BL, BM, BS, etc.
    # showDummyISIN= "FALSE"                  #GFDL : Optional parameter. When true, instruments with dummy ISIN will be included in response.(Applicable only for Equity / CASH)
    # showETF= "FALSE"                          #GFDL : Optional parameter. When true, ETF instruments will be included in response.(Applicable only for Equity / CASH)
    # showInterOperable= "FALSE"            #GFDL : Optional parameter. When true, InterOperable instruments will be included in response with special character (#/ $).(Applicable only for Equity / CASH)
    # OnlyActive = "TRUE"   		            #GFDL : Optional argument (default=True) to control returned data. If false,even expired contracts are returned
    # DetailedInfo = "FALSE"                      #GFDL : Optional argument (default=False) to control returned data. If true, detailed information is returned
    
    strMessage = '{"MessageType":"GetInstruments","Exchange":"' + ExchangeName + '"}'
    # ,"OptionType":"' + OptionType + '","Expiry":"' + Expiry + '","StrikePrice":"' + str(StrikePrice)+ '"
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetServerInfo(ws):
    strMessage = '{"MessageType":"GetServerInfo"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetExchanges(ws):
    strMessage = '{"MessageType":"GetExchanges"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetInstrumentTypes(ws):
    ExchangeName = "MCX"
    strMessage = '{"MessageType":"GetInstrumentTypes","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetProducts(ws):
    ExchangeName = "NFO"
    strMessage = '{"MessageType":"GetProducts","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetExpiryDates(ws):
    ExchangeName = "NFO"
    strMessage = '{"MessageType":"GetExpiryDates","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetOptionTypes(ws):
    ExchangeName = "NFO"
    strMessage = '{"MessageType":"GetOptionTypes","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetStrikePrices(ws):
    ExchangeName = "NFO"
    strMessage = '{"MessageType":"GetStrikePrices","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLimitation(ws):
    strMessage = '{"MessageType":"GetLimitation"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetMarketMessages(ws):
    ExchangeName = "NFO"
    strMessage = '{"MessageType":"GetMarketMessages","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetExchangeMessages(ws):
    ExchangeName = "NSE"
    strMessage = '{"MessageType":"GetExchangeMessages","Exchange":"' + ExchangeName + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteOptionChain(ws):
    Exchange = "NFO"                                   # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Product = "RELIANCE"                               # GFDL : Mandatory Parameter. Example, RELIANCE, BANKNIFTY, NIFTY
    # Expiry = "23JAN2020"                             # GFDL : Optional field, in DDMMMYYYY format. If absent, result is sent for all active Expiries
    # OptionType = "CE"                                # GFDL : Optional field, CE or PE. If absent, result is sent for all Option Types
    # StrikePrice = 10000                              # GFDL : Optional field, as a number. If absent, result is sent for all strike prices
    strMessage = '{"MessageType":"GetLastQuoteOptionChain","Exchange":"' + Exchange + '","Product":"' + Product + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetExchangeSnapshot(ws):
    Exchange = "NFO"                                    # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Periodicity = "Minute"                              # GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
    Period = 1                                          # GFDL : Mandatory Parameter. Supported Values : 1,2,5,10,15,30. Default = 1
    # InstrumentType = "FUTIDX"                         # GFDL : Optional Parameter. FUTIDX, FUTSTK, OPTIDX, OPTSTK, FUTCOM, FUTCUR, etc.
    # From = 1567655100                                 # GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is
    # To = 0                                            # GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is
    # nonTraded = "false"                               # GFDL : true/false. When true, results are sent with data of even non traded instruments.
    strMessage = '{"MessageType":"GetExchangeSnapshot","Exchange":"' + Exchange + '","Period":' + f'{Period}' + ',"Periodicity":"' + Periodicity + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetExchangeSnapshotAfterMarket(ws):
    Exchange = "MCX"                                    # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Periodicity = "Minute"                              # GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
    Period = 1                                          # GFDL : Mandatory Parameter. Supported Values : 1,2,5,10,15,30. Default = 1
    # InstrumentType = "FUTIDX"                         # GFDL : Optional Parameter. FUTIDX, FUTSTK, OPTIDX, OPTSTK, FUTCOM, FUTCUR, etc.
    xDate = 1627291664                                  # GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is
    # To: 0                                             # GFDL : Epoch value of time in seconds since 1st January 1970. For example, 1567655100 is
    # nonTraded = "false"                               # GFDL : true/false. When true, results are sent with data of even non traded instruments.
    strMessage = '{"MessageType":"GetExchangeSnapshotAfterMarket","Exchange":"' + Exchange + '","Period":' + f'{Period}' + ',"Periodicity":"' + Periodicity + '","Date":"' + str(
        xDate) + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteOptionGreeks(ws):
    Exchange = "NFO"                                    # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Token = "53937"                                     # GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
    strMessage = '{"MessageType":"GetLastQuoteOptionGreeks","Exchange":"' + Exchange + '","Token":"' + str(Token) + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)


def GetLastQuoteArrayOptionGreeks(ws):
    Exchange = "NFO"                                    # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Tokens = '[{"Value":"53939"},{"Value":"53941"}]'    # GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
    strMessage = '{"MessageType":"GetLastQuoteArrayOptionGreeks","Exchange":"' + Exchange + '","Tokens":' + Tokens + '}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def GetLastQuoteOptionGreeksChain(ws):
    Exchange = "NFO"                                    # GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Product = "NIFTY"                                   # GFDL : Mandatory Parameter. Supported Values : Minute, Hour. Default = Minute
    strMessage = '{"MessageType":"GetLastQuoteOptionGreeksChain","Exchange":"' + Exchange + '","Product":"' + Product + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def SubscribeRealtimeGreeks(ws):
    Exchange ="NFO"                                     #GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
    Token = "56051" 
    Unsubscribe =  False
    strMessage = '{"MessageType":"SubscribeRealtimeGreeks","Exchange":"' + Exchange + '","Token":"' + Token + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def SubscribeOptionChain(ws):
    Exchange= "NFO"					                    #GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
    Product= "BANKNIFTY"					            #GFDL : Supported Values : RELIANCE, NIFTY, AXISBANK. Mandatory Parameter
    Expiry="04SEP2024"					                #GFDL : Format ddMMMyyyy Expiry like 30JUL2020
    # OptionType="PE"					                #GFDL : OptionTypes - CE or PE
    StrikePrice= 50000 				                    #GFDL : Strike Price like 10000, 75.5, 1250, etc.
    Depth= 5 							                #GFDL : Supported values: 1, 5, 10, 15, 20, to received count value up and down from "StrikePrice"
    # Unsubscribe= False                                #GFDL : Optional field, set to true to Unsubscribe
    strMessage = '{"MessageType":"SubscribeOptionChain","Exchange":"' + Exchange + '","Product":"' + Product + '","Expiry":"' + Expiry + '","StrikePrice":"' + f'{StrikePrice}' + '","Depth":"' +f'{Depth}' + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def SubscribeOptionChainGreeks(ws):
    Exchange= "NFO"					                    #GFDL : Supported values : NSE (stocks), NSE_IDX (Indices), NFO (F&O), MCX & CDS (Currency)
    Product= "NIFTY"					                #GFDL : Supported Values : RELIANCE, NIFTY, AXISBANK. Mandatory Parameter
    Expiry="28NOV2024"					                #GFDL : Format ddMMMyyyy Expiry like 30JUL2020
    # OptionType="PE"					                #GFDL : OptionTypes - CE or PE
    StrikePrice= 25000 				                    #GFDL : Strike Price like 10000, 75.5, 1250, etc.
    Depth= 5 							                #GFDL : Supported values: 1, 5, 10, 15, 20, to received count value up and down from "StrikePrice"
    # Unsubscribe= False                                #GFDL : Optional field, set to true to Unsubscribe
    strMessage = '{"MessageType":"SubscribeOptionChainGreeks","Exchange":"' + Exchange + '","Product":"' + Product + '","Expiry":"' + Expiry + '","StrikePrice":"' + f'{StrikePrice}' + '","Depth":"' +f'{Depth}' + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def SubscribeTopGainersLosers(ws):
    Exchange= "NFO"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Count= 5                    		                #GFDL : Supported values: 5, 10, 15, 20  ,to receive count of Top N of Gainers and Top N of Losers
    # Unsubscribe= False                                #GFDL : Optional field, set to true to Unsubscribe
    strMessage = '{"MessageType":"SubscribeTopGainersLosers","Exchange":"' + Exchange + '","Count":"' + f'{Count}'+ '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)

def GetTopGainersLosers(ws):
    Exchange= "NFO"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Count= 5                    		                #GFDL : Supported values: 5, 10, 15, 20  ,to receive count of Top N of Gainers and Top N of Losers
    strMessage = '{"MessageType":"GetTopGainersLosers","Exchange":"' + Exchange + '","Count":"' + f'{Count}'+ '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
def GetVolumeShockers(ws):
    Exchange= "NSE"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Count= 5                    		                #GFDL : Supported values: 5, 10, 15, 20  ,to receive count of N of volume shockers
    Series ="EQ"                                       #GFDL : Supported values: EQ, BE, BL, BM, BS,..
    strMessage = '{"MessageType":"GetVolumeShockers","Exchange":"' + Exchange + '","Count":"' + f'{Count}'+ '","Series":"' + Series + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
def SubscribeSnapshotGreeks(ws):
    Exchange= "NFO"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstrumentIdentifier= "NIFTY05SEP2424600CE"         #GFDL : Supported Values : NIFTY05SEP2424600CE, NIFTY20JULFUT, RELIANCE, etc.
    Periodicity= "MINUTE"				                #GFDL : Supported values are : Minute
    Period= 1							                #GFDL : Supported values are : 1 (for Minute Periodicity ONLY)`    
    Unsubscribe= "false"                                #GFDL : Optional field, set to true to Unsubscribe
    strMessage = '{"MessageType":"SubscribeSnapshotGreeks","Exchange":"' + Exchange + '","InstrumentIdentifier":"' + InstrumentIdentifier + '","Periodicity":"' + Periodicity + '","Period":"' + str(Period) + '","Unsubscribe":"' + Unsubscribe + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
def GetSnapshotGreeks(ws):
    Exchange= "NFO"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstrumentIdentifiers= '[{"Value":"NIFTY05SEP2424600CE"},{"Value":"RELIANCE"}]'       #GFDL : Supported Values : NIFTY05SEP2424600CE, NIFTY20JULFUT, RELIANCE, etc.
    Periodicity= "MINUTE"				                #GFDL : Supported values are : Minute
    Period= 1							                #GFDL : Supported values are : 1 (for Minute Periodicity ONLY)` 
    isShortIdentifiers= "true"					        #GFDL : When using contractwise symbol like NIFTY20JULFUT   

    strMessage = '{"MessageType":"GetSnapshotGreeks","Exchange":"' + Exchange + '","InstrumentIdentifiers":"' + InstrumentIdentifiers + '","Periodicity":"' + Periodicity + '","Period":"' + str(Period) + '","isShortIdentifiers":"' + isShortIdentifiers + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
def GetHistoryGreeks(ws):
    Exchange= "NFO"					                    #GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    InstrumentIdentifier= "NIFTY05SEP2424600CE"
    Periodicity= "MINUTE"				                #GFDL : Supported values are : Minute
    Period= 1							                #GFDL : Supported values are : 1 (for Minute Periodicity ONLY)`
    isShortIdentifier= "true"					        #GFDL : When using contractwise symbol like NIFTY20JULFUT, 
														#this argument must be sent with value "true" 
															
    # From= 1723458803							        #Start time of the History as per Epoch time (1st January 1970)
															#Visit https://www.epochconverter.com/ to get formulae to convert human readable 
															#time to Epoch and vice versa (scroll to end of their home page)
															
															#If you need entire possible history, send From value as 0
															
    # To= 1723433400									#End time of the History as per Epoch. To request data till latest moment, 
															#skip this argument or send time in Future (e.g. current time + 1 hour)
															
    Max= 10								                #Specify this argument to control the number of records returned.
													    #For example, send Max:10 to request only latest 10 records
    strMessage = '{"MessageType":"GetHistoryGreeks","Exchange":"' + Exchange + '","InstrumentIdentifier":"' + InstrumentIdentifier + '","Periodicity":"' + Periodicity + '","Period":"' + str(Period) + '","Max":"' + str(Max) + '","isShortIdentifier":"' + isShortIdentifier + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
    
def GetVolumeShockers(ws):
    Exchange ="NSE"					#GFDL : Supported Values : NFO, NSE, NSE_IDX, CDS, MCX. Mandatory Parameter
    Count= 5                    		#GFDL : Supported values: 5, 10, 15, 20  ,to receive count of Top N of Gainers and Top N of Losers
    Series ="EQ"
    strMessage = '{"MessageType":"GetVolumeShockers","Exchange":"' + Exchange + '","Count":"' + f'{Count}'+ '","Series":"' + Series + '"}'
    print('SENT: ' + strMessage)
    ws.send(strMessage)
    
    
def on_message(ws, message):
    
    print("Response : " + message)
    with open("response.txt", "a") as file:
        file.write("Response : " + message + "\n")
    # Authenticate : {"Complete":true,"Message":"Welcome!","MessageType":"AuthenticateResult"}
    allures = message.split(',')
    strComplete = allures[0].split(':')
    result = str(strComplete[1])
    # print('Response : ' + result)
    if result == "true":
        print('AUTHENTICATED!!!')
        # SubscribeRealtime(ws)  # GFDL : Subscribes to realtime data (server will push new data whenever available)
        # SubscribeSnapshot(ws)                  # GFDL : Subscribes to minute snapshot data (server will push new data whenever available)

        # GetLastQuote(ws)                       #GFDL : Returns LastTradePrice of Single Symbol (detailed)
        # GetLastQuoteShort(ws)                  # GFDL : Returns LastTradePrice of Single Symbol (short)
        # GetLastQuoteShortWithClose(ws)         #GFDL : Returns LastTradePrice of Single Symbol (short) with Close of Previous Day

        # GetLastQuoteArray(ws)                  #GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (detailed)
        # GetLastQuoteArrayShort(ws)             #GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (short)
        # GetLastQuoteArrayShortWithClose(ws)    #GFDL : Returns LastTradePrice of multiple Symbols – max 25 in single call (short) with Previous Close

        # GetSnapshot(ws)                        #GFDL : Returns latest Snapshot Data of multiple Symbols – max 25 in single call
        # GetHistory(ws)                         #GFDL : Returns historical data (Tick / Minute / EOD)

        # GetInstrumentsOnSearch(ws)             #GFDL : Returns array of max. 20 instruments by selected exchange and 'search string'
        # GetInstruments(ws)                     #GFDL : Returns array of instruments by selected exchange

        GetServerInfo(ws)                      #GFDL : Returns the server endpoint where user is connected
        # GetExchanges(ws)                       #GFDL : Returns array of available exchanges configured for API Key
        # GetInstrumentTypes(ws)                 #GFDL : Returns list of Instrument Types (e.g. FUTIDX, FUTSTK, etc.)
        # GetProducts(ws)                        #GFDL : Returns list of Products (e.g. NIFTY, BANKNIFTY, GAIL, etc.)
        # GetExpiryDates(ws)                     #GFDL : Returns array of Expiry Dates (e.g. 25JUN2020, 30JUL2020, etc.)
        # GetOptionTypes(ws)                     #GFDL : Returns list of Option Types (e.g. CE, PE, etc.)
        # GetStrikePrices(ws)                    #GFDL : Returns list of Strike Prices (e.g. 10000, 11000, 75.5, etc.)
        # GetLimitation(ws)                      #GFDL : Returns user account information (functions allowed, Exchanges allowed, symbol limit, etc.)

        # GetMarketMessages(ws)                  #GFDL : Returns array of last messages (Market Messages) related to selected exchange
        # GetExchangeMessages(ws)				#GFDL : Returns array of last messages (Exchange Messages) related to selected exchange

        # GetLastQuoteOptionChain(ws)			    #GFDL : Returns OptionChain data in realtime
        # GetExchangeSnapshot(ws)                   #GFDL : Returns entire Exchange Snapshot in realtime
        # GetExchangeSnapshotAfterMarket(ws)        #GFDL : Returns entire Exchange Snapshot after market.

        # GetLastQuoteOptionGreeks(ws)              #GFDL : Returns Last Traded Option Greek values of Single Symbol
        # GetLastQuoteArrayOptionGreeks(ws)         #GFDL : Returns Last Traded Option Greek values of multiple Symbols – max 25 in single call
        # GetLastQuoteOptionGreeksChain(ws)         #GFDL : Returns Last Traded Option Greek values of entire OptionChain of requested underlying
        # SubscribeRealtimeGreeks(ws)                   #GFDL : pushes realtime greeks every second for the subscribed token from server
        # SubscribeSnapshotGreeks(ws)               #GFDL : Realtime Greeks Snapshots data, returns data snapshot as per Periodicity & Period values
        # GetSnapshotGreeks(ws)                  #GFDL : Returns latest Snapshot Greek Data of multiple Symbols – max 25 in single call
        # SubscribeOptionChain(ws)
        # SubscribeOptionChainGreeks(ws)
        # SubscribeTopGainersLosers(ws)
        # GetTopGainersLosers(ws)
        # GetHistoryGreeks(ws)
        # GetVolumeShockers(ws)
        
def on_error(ws, error):
    print(error)
    print("Error")


def on_close(ws):
    print("Reconnecting...")
    websocket.setdefaulttimeout(30)
    ws.connect(endpoint)


def on_open(ws):
    # print("Connected...")
    def run(*args):
        time.sleep(1)
        Authenticate(ws)

    thread.start_new_thread(run, ())


if __name__ == "__main__":
    websocket.enableTrace(False)
    ws = websocket.WebSocketApp(endpoint,
                                on_open=on_open,
                                on_message=on_message,
                                on_error=on_error,
                                on_close=on_close)

    ws.run_forever()
